
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; hbios provided labels found in romwbw shim ;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; HBIOS FUNCTIONS
;
PUBLIC BF_CIOIN             ; CHARACTER INPUT
PUBLIC BF_CIOOUT            ; CHARACTER OUTPUT
PUBLIC BF_CIOIST            ; CHARACTER INPUT STATUS
PUBLIC BF_CIOOST            ; CHARACTER OUTPUT STATUS
PUBLIC BF_CIOINIT           ; INIT/RESET DEVICE/LINE CONFIG
PUBLIC BF_CIOQUERY          ; REPORT DEVICE/LINE CONFIG
PUBLIC BF_CIODEVICE         ; REPORT DEVICE INFO
;
PUBLIC BF_DIOSTATUS         ; DISK STATUS
PUBLIC BF_DIORESET          ; DISK RESET
PUBLIC BF_DIOSEEK           ; DISK SEEK
PUBLIC BF_DIOREAD           ; DISK READ SECTORS
PUBLIC BF_DIOWRITE          ; DISK WRITE SECTORS
PUBLIC BF_DIOVERIFY         ; DISK VERIFY SECTORS
PUBLIC BF_DIOFORMAT         ; DISK FORMAT TRACK
PUBLIC BF_DIODEVICE         ; DISK DEVICE INFO REPORT
PUBLIC BF_DIOMEDIA          ; DISK MEDIA REPORT
PUBLIC BF_DIODEFMED         ; DEFINE DISK MEDIA
PUBLIC BF_DIOCAP            ; DISK CAPACITY REPORT
PUBLIC BF_DIOGEOM           ; DISK GEOMETRY REPORT
;
PUBLIC BF_RTCGETTIM         ; GET TIME
PUBLIC BF_RTCSETTIM         ; SET TIME
PUBLIC BF_RTCGETBYT         ; GET NVRAM BYTE BY INDEX
PUBLIC BF_RTCSETBYT         ; SET NVRAM BYTE BY INDEX
PUBLIC BF_RTCGETBLK         ; GET NVRAM DATA BLOCK
PUBLIC BF_RTCSETBLK         ; SET NVRAM DATA BLOCK
;
PUBLIC BF_EMU               ; DEPRECATED
;
PUBLIC BF_VDAINI            ; INITIALIZE VDU
PUBLIC BF_VDAQRY            ; QUERY VDU STATUS
PUBLIC BF_VDARES            ; SOFT RESET VDU
PUBLIC BF_VDADEV            ; DEVICE INFO
PUBLIC BF_VDASCS            ; SET CURSOR STYLE
PUBLIC BF_VDASCP            ; SET CURSOR POSITION
PUBLIC BF_VDASAT            ; SET CHARACTER ATTRIBUTE
PUBLIC BF_VDASCO            ; SET CHARACTER COLOR
PUBLIC BF_VDAWRC            ; WRITE CHARACTER
PUBLIC BF_VDAFIL            ; FILL
PUBLIC BF_VDACPY            ; COPY
PUBLIC BF_VDASCR            ; SCROLL
PUBLIC BF_VDAKST            ; GET KEYBOARD STATUS
PUBLIC BF_VDAKFL            ; FLUSH KEYBOARD BUFFER
PUBLIC BF_VDAKRD            ; READ KEYBOARD
;
PUBLIC BF_SYSRESET          ; SOFT RESET HBIOS
PUBLIC BF_SYSVER            ; GET HBIOS VERSION
PUBLIC BF_SYSSETBNK         ; SET CURRENT BANK
PUBLIC BF_SYSGETBNK         ; GET CURRENT BANK
PUBLIC BF_SYSSETCPY         ; BANK MEMORY COPY SETUP
PUBLIC BF_SYSBNKCPY         ; BANK MEMORY COPY
PUBLIC BF_SYSALLOC          ; ALLOC HBIOS HEAP MEMORY
PUBLIC BF_SYSFREE           ; FREE HBIOS HEAP MEMORY
PUBLIC BF_SYSGET            ; GET HBIOS INFO
PUBLIC BF_SYSSET            ; SET HBIOS PARAMETERS
PUBLIC BF_SYSPEEK           ; GET A BYTE VALUE FROM ALT BANK
PUBLIC BF_SYSPOKE           ; SET A BYTE VALUE IN ALT BANK
PUBLIC BF_SYSINT            ; MANAGE INTERRUPT VECTORS
;
PUBLIC BF_SYSGET_CIOCNT     ; GET CHAR UNIT COUNT
PUBLIC BF_SYSGET_DIOCNT     ; GET DISK UNIT COUNT
PUBLIC BF_SYSGET_VDACNT     ; GET VDA UNIT COUNT
PUBLIC BF_SYSGET_TIMER      ; GET CURRENT TIMER VALUE
PUBLIC BF_SYSGET_SECS       ; GET CURRENT SECONDS VALUE
PUBLIC BF_SYSGET_BOOTINFO   ; GET BOOT INFORMATION
PUBLIC BF_SYSGET_CPUINFO    ; GET CPU INFORMATION
PUBLIC BF_SYSGET_MEMINFO    ; GET MEMORY CAPACTITY INFO
PUBLIC BF_SYSGET_BNKINFO    ; GET BANK ASSIGNMENT INFO
;
PUBLIC BF_SYSSET_TIMER      ; SET TIMER VALUE
PUBLIC BF_SYSSET_SECS       ; SET SECONDS VALUE
PUBLIC BF_SYSSET_BOOTINFO   ; SET BOOT INFORMATION
;
PUBLIC BF_SYSINT_INFO       ; GET INTERRUPT SYSTEM INFO
PUBLIC BF_SYSINT_GET        ; GET INT VECTOR ADDRESS
PUBLIC BF_SYSINT_SET        ; SET INT VECTOR ADDRESS
;
; CHAR DEVICE IDS
;
PUBLIC CIODEV_UART
PUBLIC CIODEV_ASCI
PUBLIC CIODEV_TERM
PUBLIC CIODEV_PRPCON
PUBLIC CIODEV_PPPCON
PUBLIC CIODEV_SIO
PUBLIC CIODEV_ACIA
PUBLIC CIODEV_PIO
PUBLIC CIODEV_UF
PUBLIC CIODEV_CONSOLE
;
; SUB TYPES OF CHAR DEVICES
;
;00 RS-232
;01 TERMINAL
;02 PARALLEL PORT
;03 UNUSED
;
; DISK DEVICE IDS
;
PUBLIC DIODEV_MD
PUBLIC DIODEV_FD
PUBLIC DIODEV_RF
PUBLIC DIODEV_IDE
PUBLIC DIODEV_ATAPI
PUBLIC DIODEV_PPIDE
PUBLIC DIODEV_SD
PUBLIC DIODEV_PRPSD
PUBLIC DIODEV_PPPSD
PUBLIC DIODEV_HDSK
;
; VIDEO DEVICE IDS
;
PUBLIC VDADEV_VDU   ; ECB VDU - MOTOROLA 6545
PUBLIC VDADEV_CVDU  ; ECB COLOR VDU - MOS 8563
PUBLIC VDADEV_NEC   ; ECB UPD7220 - NEC UPD7220
PUBLIC VDADEV_TMS   ; N8 ONBOARD VDA SUBSYSTEM - TMS 9918
PUBLIC VDADEV_VGA   ; VGA
;
; EMULATION TYPES
;
PUBLIC EMUTYP_NONE  ; NONE
PUBLIC EMUTYP_TTY   ; TTY
PUBLIC EMUTYP_ANSI  ; ANSI
;
; HBIOS PROXY COMMON DATA BLOCK
;
PUBLIC HB_CURBNK    ; CURRENTLY ACTIVE LOW MEMORY BANK ID
PUBLIC HB_INVBNK    ; BANK ACTIVE AT TIME OF HBIOS CALL INVOCATION
PUBLIC HB_SRCADR    ; BNKCPY: DESTINATION BANK ID
PUBLIC HB_SRCBNK    ; BNKCPY: SOURCE BANK ID
PUBLIC HB_DSTADR    ; BNKCPY: DESTINATION ADDRESS
PUBLIC HB_DSTBNK    ; BNKCPY: SOURCE ADDRESS
PUBLIC HB_CPYLEN    ; BNKCPY: COPY LENGTH
;
PUBLIC HB_INVOKE    ; INVOKE HBIOS FUNCTION
PUBLIC HB_BNKSEL    ; SELECT LOW MEMORY BANK ID
PUBLIC HB_BNKCPY    ; INTERBANK MEMORY COPY
PUBLIC HB_BNKCALL   ; INTERBANK FUNCTION CALL
PUBLIC HB_IDENT     ; POINTER TO HBIOS IDENT DATA BLOCK

;----------------------------------------------------------------------

defc BF_CIO         =    $00
defc BF_CIOIN       =    BF_CIO + 0     ; CHARACTER INPUT
defc BF_CIOOUT      =    BF_CIO + 1     ; CHARACTER OUTPUT
defc BF_CIOIST      =    BF_CIO + 2     ; CHARACTER INPUT STATUS
defc BF_CIOOST      =    BF_CIO + 3     ; CHARACTER OUTPUT STATUS
defc BF_CIOINIT     =    BF_CIO + 4     ; INIT/RESET DEVICE/LINE CONFIG
defc BF_CIOQUERY    =    BF_CIO + 5     ; REPORT DEVICE/LINE CONFIG
defc BF_CIODEVICE   =    BF_CIO + 6     ; REPORT DEVICE INFO
;
defc BF_DIO         =    $10
defc BF_DIOSTATUS   =    BF_DIO + 0     ; DISK STATUS
defc BF_DIORESET    =    BF_DIO + 1     ; DISK RESET
defc BF_DIOSEEK     =    BF_DIO + 2     ; DISK SEEK
defc BF_DIOREAD     =    BF_DIO + 3     ; DISK READ SECTORS
defc BF_DIOWRITE    =    BF_DIO + 4     ; DISK WRITE SECTORS
defc BF_DIOVERIFY   =    BF_DIO + 5     ; DISK VERIFY SECTORS
defc BF_DIOFORMAT   =    BF_DIO + 6     ; DISK FORMAT TRACK
defc BF_DIODEVICE   =    BF_DIO + 7     ; DISK DEVICE INFO REPORT
defc BF_DIOMEDIA    =    BF_DIO + 8     ; DISK MEDIA REPORT
defc BF_DIODEFMED   =    BF_DIO + 9     ; DEFINE DISK MEDIA
defc BF_DIOCAP      =    BF_DIO + 10    ; DISK CAPACITY REPORT
defc BF_DIOGEOM     =    BF_DIO + 11    ; DISK GEOMETRY REPORT
;
defc BF_RTC         =    $20
defc BF_RTCGETTIM   =    BF_RTC + 0     ; GET TIME
defc BF_RTCSETTIM   =    BF_RTC + 1     ; SET TIME
defc BF_RTCGETBYT   =    BF_RTC + 2     ; GET NVRAM BYTE BY INDEX
defc BF_RTCSETBYT   =    BF_RTC + 3     ; SET NVRAM BYTE BY INDEX
defc BF_RTCGETBLK   =    BF_RTC + 4     ; GET NVRAM DATA BLOCK
defc BF_RTCSETBLK   =    BF_RTC + 5     ; SET NVRAM DATA BLOCK
;
defc BF_EMU         =    $30            ; DEPRECATED
;
defc BF_VDA         =    $40
defc BF_VDAINI      =    BF_VDA + 0     ; INITIALIZE VDU
defc BF_VDAQRY      =    BF_VDA + 1     ; QUERY VDU STATUS
defc BF_VDARES      =    BF_VDA + 2     ; SOFT RESET VDU
defc BF_VDADEV      =    BF_VDA + 3     ; DEVICE INFO
defc BF_VDASCS      =    BF_VDA + 4     ; SET CURSOR STYLE
defc BF_VDASCP      =    BF_VDA + 5     ; SET CURSOR POSITION
defc BF_VDASAT      =    BF_VDA + 6     ; SET CHARACTER ATTRIBUTE
defc BF_VDASCO      =    BF_VDA + 7     ; SET CHARACTER COLOR
defc BF_VDAWRC      =    BF_VDA + 8     ; WRITE CHARACTER
defc BF_VDAFIL      =    BF_VDA + 9     ; FILL
defc BF_VDACPY      =    BF_VDA + 10    ; COPY
defc BF_VDASCR      =    BF_VDA + 11    ; SCROLL
defc BF_VDAKST      =    BF_VDA + 12    ; GET KEYBOARD STATUS
defc BF_VDAKFL      =    BF_VDA + 13    ; FLUSH KEYBOARD BUFFER
defc BF_VDAKRD      =    BF_VDA + 14    ; READ KEYBOARD
;
defc BF_SYS         =    $F0
defc BF_SYSRESET    =    BF_SYS + 0     ; SOFT RESET HBIOS
defc BF_SYSVER      =    BF_SYS + 1     ; GET HBIOS VERSION
defc BF_SYSSETBNK   =    BF_SYS + 2     ; SET CURRENT BANK
defc BF_SYSGETBNK   =    BF_SYS + 3     ; GET CURRENT BANK
defc BF_SYSSETCPY   =    BF_SYS + 4     ; BANK MEMORY COPY SETUP
defc BF_SYSBNKCPY   =    BF_SYS + 5     ; BANK MEMORY COPY
defc BF_SYSALLOC    =    BF_SYS + 6     ; ALLOC HBIOS HEAP MEMORY
defc BF_SYSFREE     =    BF_SYS + 7     ; FREE HBIOS HEAP MEMORY
defc BF_SYSGET      =    BF_SYS + 8     ; GET HBIOS INFO
defc BF_SYSSET      =    BF_SYS + 9     ; SET HBIOS PARAMETERS
defc BF_SYSPEEK     =    BF_SYS + 10    ; GET A BYTE VALUE FROM ALT BANK
defc BF_SYSPOKE     =    BF_SYS + 11    ; SET A BYTE VALUE IN ALT BANK
defc BF_SYSINT      =    BF_SYS + 12    ; MANAGE INTERRUPT VECTORS
;
defc BF_SYSGET_CIOCNT   =    $00    ; GET CHAR UNIT COUNT
defc BF_SYSGET_DIOCNT   =    $10    ; GET DISK UNIT COUNT
defc BF_SYSGET_VDACNT   =    $40    ; GET VDA UNIT COUNT
defc BF_SYSGET_TIMER    =    $D0    ; GET CURRENT TIMER VALUE
defc BF_SYSGET_SECS     =    $D1    ; GET CURRENT SECONDS VALUE
defc BF_SYSGET_BOOTINFO =    $E0    ; GET BOOT INFORMATION
defc BF_SYSGET_CPUINFO  =    $F0    ; GET CPU INFORMATION
defc BF_SYSGET_MEMINFO  =    $F1    ; GET MEMORY CAPACTITY INFO
defc BF_SYSGET_BNKINFO  =    $F2    ; GET BANK ASSIGNMENT INFO
;
defc BF_SYSSET_TIMER    =    $D0    ; SET TIMER VALUE
defc BF_SYSSET_SECS     =    $D1    ; SET SECONDS VALUE
defc BF_SYSSET_BOOTINFO =    $E0    ; SET BOOT INFORMATION
;
defc BF_SYSINT_INFO     =    $00    ; GET INTERRUPT SYSTEM INFO
defc BF_SYSINT_GET      =    $10    ; GET INT VECTOR ADDRESS
defc BF_SYSINT_SET      =    $20    ; SET INT VECTOR ADDRESS
;
; CHAR DEVICE IDS
;
defc CIODEV_UART    =    $00
defc CIODEV_ASCI    =    $10
defc CIODEV_TERM    =    $20
defc CIODEV_PRPCON  =    $30
defc CIODEV_PPPCON  =    $40
defc CIODEV_SIO     =    $50
defc CIODEV_ACIA    =    $60
defc CIODEV_PIO     =    $70
defc CIODEV_UF      =    $80
defc CIODEV_CONSOLE =    $D0
;
; SUB TYPES OF CHAR DEVICES
;
;00 RS-232
;01 TERMINAL
;02 PARALLEL PORT
;03 UNUSED
;
; DISK DEVICE IDS
;
defc DIODEV_MD      =    $00
defc DIODEV_FD      =    $10
defc DIODEV_RF      =    $20
defc DIODEV_IDE     =    $30
defc DIODEV_ATAPI   =    $40
defc DIODEV_PPIDE   =    $50
defc DIODEV_SD      =    $60
defc DIODEV_PRPSD   =    $70
defc DIODEV_PPPSD   =    $80
defc DIODEV_HDSK    =    $90
;
; VIDEO DEVICE IDS
;
defc VDADEV_VDU     =    $00        ; ECB VDU - MOTOROLA 6545
defc VDADEV_CVDU    =    $10        ; ECB COLOR VDU - MOS 8563
defc VDADEV_NEC     =    $20        ; ECB UPD7220 - NEC UPD7220
defc VDADEV_TMS     =    $30        ; N8 ONBOARD VDA SUBSYSTEM - TMS 9918
defc VDADEV_VGA     =    $40        ; VGA
;
; EMULATION TYPES
;
defc EMUTYP_NONE    =    0          ; NONE
defc EMUTYP_TTY     =    1          ; TTY
defc EMUTYP_ANSI    =    2          ; ANSI
;
; HBIOS PROXY COMMON DATA BLOCK
; EXACTLY 32 BYTES AT $FFE0-$FFFF
;
defc HBX_XFC        =    $10000 - $20           ; HBIOS PROXY INTERFACE AREA, 32 BYTES FIXED
;
defc HBX_XFCDAT     =    HBX_XFC                ; DATA PORTION OF HBIOS PROXY INTERFACE AREA
defc HB_CURBNK      =    HBX_XFCDAT + 0         ; CURRENTLY ACTIVE LOW MEMORY BANK ID
defc HB_INVBNK      =    HBX_XFCDAT + 1         ; BANK ACTIVE AT TIME OF HBIOS CALL INVOCATION
defc HB_SRCADR      =    HBX_XFCDAT + 2         ; BNKCPY: DESTINATION BANK ID
defc HB_SRCBNK      =    HBX_XFCDAT + 4         ; BNKCPY: SOURCE BANK ID
defc HB_DSTADR      =    HBX_XFCDAT + 5         ; BNKCPY: DESTINATION ADDRESS
defc HB_DSTBNK      =    HBX_XFCDAT + 7         ; BNKCPY: SOURCE ADDRESS
defc HB_CPYLEN      =    HBX_XFCDAT + 8         ; BNKCPY: COPY LENGTH
;
defc HBX_XFCFNS     =    HBX_XFC + $10          ; JUMP TABLE PORTION OF HBIOS PROXY INTERFACE AREA
defc HB_INVOKE      =    HBX_XFCFNS + (0 * 3)   ; INVOKE HBIOS FUNCTION
defc HB_BNKSEL      =    HBX_XFCFNS + (1 * 3)   ; SELECT LOW MEMORY BANK ID
defc HB_BNKCPY      =    HBX_XFCFNS + (2 * 3)   ; INTERBANK MEMORY COPY
defc HB_BNKCALL     =    HBX_XFCFNS + (3 * 3)   ; INTERBANK FUNCTION CALL
defc HB_IDENT       =    HBX_XFCFNS + 14        ; POINTER TO HBIOS IDENT DATA BLOCK
